/**
 * Function is triggered on click
 * Needs to be stored as onclick attribute on HTML UI Elements
 * e.g. <button id="element" onclick="indicateClick(this)">Click me</button>
 *
 * It indicates this click by adding / removing a class on the clicked item
 * and also on the documents body.
 *
 * Class on clicked item:  this--is-clicked
 * Class on body:          element--is-clicked
 * --> 'element' is always the id from the clicked button!
 *
 * @param clickedElement    DOM node of clicked element
 */
function indicateClick( clickedElement )
{
    let theClickedID = clickedElement.id;

    // de-/indicate the clicked element
    clickedElement.classList.toggle( 'this--is-clicked' );

    // de-/indicate the clicked element id on body
    toggleBodyClass( theClickedID+'--is-clicked' );
}





/**
 * Function toggles given classname on body.
 *
 * @param classname string      e.g. "overlay--is-visible"
 */
function toggleBodyClass( classname )
{
    document.body.classList.toggle( classname );
}





/**
 * Function awaits in target ID and a classname.
 * Toggles this classname on target, if it exists.
 *
 * e.g. <button onclick="toggleClassOnElement('navigation', 'come--in');">click me</button>
 *
 * @param targetID string   the id of the target
 * @param classname string  the class to toggle
 */
function toggleClassOnElement( targetID, classname ){
    let target = document.getElementById( targetID );

    if( target !== undefined ){
        target.classList.toggle( classname );
    }
}